/*---------------------------------------------------------------------------+
| PMSPY HELP Dialog Procedure
|
| Change History:
| ---------------
| $C1=1.03,06/19/89,smd,added HELP dialog parameter structure
|
+---------------------------------------------------------------------------*/

#include "pmspy.h"

 /***************************************************************************************
  *
  *                       Entry
  *
  ***************************************************************************************/

 MRESULT EXPENTRY HelpWindowProc(         HWND    hwnd,
                                 register USHORT  message,
                                          MPARAM  lParam1,
                                          MPARAM  lParam2 )

  {

   /***********************************************************************************
    *
    *                   Local Variables
    *
    ***********************************************************************************/

     ULONG       retcode;

     PHELP_DATA  pData;                         /* @C1A - unique dialog data */

 /****************************************************************************
  *
  * get pointer to unique data for this instance of the dialog
  *
  ****************************************************************************/

 pData = (PHELP_DATA) WinQueryWindowULong(hwnd, QWL_USER);   /* @C1A */

 /***************************************************************************************
  *
  *  Process the message
  *
  ***************************************************************************************/

    switch (message)                                    /* Switch off of the message ID */
      {

        case WM_COMMAND:

          switch( LOUSHORT( lParam1 ) )
          {
              /**************************************************************************
               *
               *  User cancelled exclusion/inclusion
               *
               **************************************************************************/

              case DID_CANCEL:                          /* CANCEL was selected          */

                  WinDismissDlg( hwnd,                  /* Close dialog */
                                 NULL );                /* WinDlgBox return */

                break;                                  /* Break DID_CANCEL             */
          }

            retcode = NULL;                             /* retcode for any WM_COMMAND   */
            break;                                      /* Break WM_COMMAND             */

        /********************************************************************************/
        /**                                                                            **/
        /** WM_CLOSE:                                                                  **/
        /** - Call WinDismissDlg to close the dialog box                               **/
        /**                                                                            **/
        /********************************************************************************/

        case WM_CLOSE:                                  /* Close Dialog Box.            */

          WinDismissDlg( hwnd, NULL);
          retcode = TRUE;

          break;                                                                           /* DB  @P4A */

        /*******************************************************************************
         *
         *  WM_INITDLG:
         *  - Init pointer to data pointed to by WinDlgBox
         *  - Init global handle of this dlg
         *
         ********************************************************************************/

        case WM_INITDLG:
             {
               CHAR    szHelpLine[256];

              /******************************************************************************
               *
               * save instance's unique data for all subsequeunt dialog calls
               *
               ******************************************************************************/

               WinSetWindowULong(hwnd,
                                 QWL_USER,
                                 (ULONG) (pData = (PHELP_DATA)lParam2));

              /******************************************************************************
               *
               *  Load HELP text resource
               *
               ******************************************************************************/

               OpenPDTR( &pData->hPDTR );

              /******************************************************************************
               *
               *   Set Window Title As so instructed
               *
               ******************************************************************************/

               WinSetWindowText( WinWindowFromID(hwnd, FID_TITLEBAR),
                                 Strings[pData->titleID]);

              /******************************************************************************
               *
               *   Add all Help text to list box
               *
               ******************************************************************************/

               while( !EofPDTR(&pData->hPDTR) )
               {
                 GetsPDTR(&pData->hPDTR,szHelpLine,sizeof(szHelpLine));

                 WinSendDlgItemMsg( hwnd,                 /* Window Handle */
                                    IDD_HELP,
                                    LM_INSERTITEM,        /* Insert item   */
                                    (MPARAM) LIT_END,     /* @ end         */
                                    (MPARAM) szHelpLine); /* Text          */
               }

              /******************************************************************************
               *
               *   Free the HELP resource
               *
               ******************************************************************************/

               ClosePDTR( &pData->hPDTR );
             }
          retcode = FALSE;
          break;                                        /* WM_INITDLG                   */

        default:                                        /* Any other message            */
          retcode =  (ULONG)WinDefDlgProc(              /* Return message to default prc*/
                        hwnd,                           /* Dialog Handle                */
                        message,                        /* Message                      */
                        lParam1,                        /* First parameter for message. */
                        lParam2);                       /* Second parameter for message.*/
      }                                                 /* End switch                   */

 /***************************************************************************************
  *
  *                       Exit
  *
  ***************************************************************************************/

   return((MRESULT) retcode);
}
